@echo off
rem ***********************************************************************************
rem **************BitSight Daily Launcher Batch File**************
rem **************Version: 1.0
rem ***********************************************************************************

rem SET Archer Instance name here
set ArcherInstanceName=Dev

rem NOTE: Script current working directory ("Start in" if using Windows Task Scheduler) needs to be where this batch file and node files exist.
rem Get the current directory
set BitSightPath=%CD%

rem Get date time stamp for log file
set t=%date%_%time% 
set d=%t:~10,4%%t:~4,2%%t:~7,2%_%t:~15,2%%t:~18,2%
set d=%d: =0%

rem Create log file directory if it doesn't already exist
md "%BitSightPath%\Logs" 2>nul
md "%BitSightPath%\Logs\Daily" 2>nul
md "%BitSightPath%\Logs\100" 2>nul
md "%BitSightPath%\Logs\110" 2>nul
md "%BitSightPath%\Logs\120" 2>nul
md "%BitSightPath%\Logs\130" 2>nul
rem @ECHO Completed setting up log directories

rem Set the log file name
set logfile="%BitSightPath%\Logs\Daily\DailyOverall_%d%.txt"

rem Clean up existing error files if they exist
IF EXIST "%BitSightPath%\Logs\error-100.txt" (
  DEL "%BitSightPath%\Logs\error-100.txt"
)
IF EXIST "%BitSightPath%\Logs\error-110.txt" (
  DEL "%BitSightPath%\Logs\error-110.txt"
)
IF EXIST "%BitSightPath%\Logs\error-120.txt" (
  DEL "%BitSightPath%\Logs\error-120.txt"
)
IF EXIST "%BitSightPath%\Logs\error-130.txt" (
  DEL "%BitSightPath%\Logs\error-130.txt"
)

rem Clean up existing success files if they exist
IF EXIST "%BitSightPath%\Logs\success-100.txt" (
  DEL "%BitSightPath%\Logs\success-100.txt"
)
IF EXIST "%BitSightPath%\Logs\success-110.txt" (
  DEL "%BitSightPath%\Logs\success-110.txt"
)
IF EXIST "%BitSightPath%\Logs\success-120.txt" (
  DEL "%BitSightPath%\Logs\success-120.txt"
)
IF EXIST "%BitSightPath%\Logs\success-130.txt" (
  DEL "%BitSightPath%\Logs\success-130.txt"
)


rem Launch 100 script
echo %BitSightPath%\100-BitSightTPPSearch.js Starting... >> %logfile% 2>&1
node "%BitSightPath%\100-BitSightTPPSearch.js" > "%BitSightPath%\Logs\100-BitSightTPPSearch.log" 2>&1

set errFound=0
IF EXIST "%BitSightPath%\Logs\error-100.txt" (
	set errFound=1
	echo "Error with 100 - Error Log found"
)

IF NOT EXIST "%BitSightPath%\Logs\success-100.txt" (
	set errFound=1
	echo "Error with 100 - Success Log not found"
)


rem Launch 110 script
echo %BitSightPath%\110-BitSightGetHeadlineRatingsNewLicense.js Starting... >> %logfile% 2>&1
node "%BitSightPath%\110-BitSightGetHeadlineRatingsNewLicense.js" > "%BitSightPath%\Logs\110-BitSightGetHeadlineRatingsNewLicense.log" 2>&1

IF EXIST "%BitSightPath%\Logs\error-110.txt" (
	set errFound=1
	echo "Error with 110 - Error Log found"
)

IF NOT EXIST "%BitSightPath%\Logs\success-110.txt" (
	set errFound=1
	echo "Error with 110 - Success Log not found"
)


rem Launch 120 script
echo %BitSightPath%\120-ChangeSubscriptions.js Starting... >> %logfile% 2>&1
node "%BitSightPath%\120-ChangeSubscriptions.js" > "%BitSightPath%\Logs\120-ChangeSubscriptions.log" 2>&1

IF EXIST "%BitSightPath%\Logs\error-120.txt" (
	set errFound=1
	echo "Error with 120 - Error Log found"
)

IF NOT EXIST "%BitSightPath%\Logs\success-120.txt" (
	set errFound=1
	echo "Error with 120 - Success Log not found"
)


rem Launch 130 script
echo %BitSightPath%\130-BitSightGetBAAVectors.js Starting... >> %logfile% 2>&1
node "%BitSightPath%\130-BitSightGetBAAVectors.js" > "%BitSightPath%\Logs\130-BitSightGetBAAVectors.log" 2>&1

IF EXIST "%BitSightPath%\Logs\error-130.txt" (
	set errFound=1
	echo "Error with 130 - Error Log found"
)

IF NOT EXIST "%BitSightPath%\Logs\success-130.txt" (
	set errFound=1
	echo "Error with 130 - Success Log not found"
)



rem Check if error file exists
IF %errFound%==1 (
	echo Overall Error! >> %logfile% 2>&1
	rem UNCOMMENT to send an email or other logging activity if desired
	rem Powershell.exe -File "%BitSightPath%\sendmailDaily.ps1" "Host Server: %COMPUTERNAME%<br>Archer Instance: %ArcherInstanceName%<br>Log File: %logfile%" 
	
	rem Format this text to anything for monitoring/alerts
	echo ERROR: BitSight Daily Job - Execution Server: %COMPUTERNAME% - Archer Instance: %ArcherInstanceName% - Log file: %logfile%
) ELSE (
	echo Overall Success! >> %logfile% 2>&1
	echo SUCCESS
)
